    <?php

    use App\Http\Controllers\ArchivosController;
    use App\Http\Controllers\CategoriasController;
    use App\Http\Controllers\CronogramasController;
    use App\Http\Controllers\EquiposController;
use App\Http\Controllers\GarchivosController;
use App\Http\Controllers\GcategoriasController;
    use App\Http\Controllers\GinventariosController;
    use App\Http\Controllers\GmantenimientosController;
    use App\Http\Controllers\GsedesController;
    use App\Http\Controllers\GsubcategoriasController;
    use App\Http\Controllers\InventarioController;
    use App\Http\Controllers\MantenimientosController;
    use App\Http\Controllers\SedeController;
    use App\Http\Controllers\ServiciosController;
    use App\Http\Controllers\SubcategoriasController;
    use App\Http\Controllers\TercerosController;
    use App\Http\Controllers\UbicacionesController;
    use App\Http\Controllers\ZonasController;
    use Illuminate\Support\Facades\Route;

    Route::get('/', function () {
        return view('welcome');
    });

    Route::get('categorias/{sede}', [CategoriasController::class, 'index']);
    Route::get('cronogramas', [CronogramasController::class, 'index']);
    Route::get('subcategorias/{categoria}', [SubcategoriasController::class, 'index']);
    Route::get('gcategorias/{sede}', [GcategoriasController::class, 'index']);
    Route::get('gsubcategorias/{categoria}', [GsubcategoriasController::class, 'index']);
    Route::get('download/{id}', [ArchivosController::class, 'download']);
    Route::get('garchivos', [GarchivosController::class, 'index']);
    Route::get('archivos', [ArchivosController::class, 'index']);
    Route::get('gdownload/{id}', [GarchivosController::class, 'download']);
    Route::apiResources([
        'ginventario' => GinventariosController::class,
        'inventario' => InventarioController::class,
        'equipos' => EquiposController::class,
        'categorias' => CategoriasController::class,
        'gcategorias' => GcategoriasController::class,
        'subcategorias' => SubcategoriasController::class,
        'gsubcategorias' => GsubcategoriasController::class,
        'sedes' => SedeController::class,
        'gsedes' => GsedesController::class,
        'servicios' => ServiciosController::class,
        'terceros' => TercerosController::class,
        'ubicaciones' => UbicacionesController::class,
        'zonas' => ZonasController::class,
        'mantenimientos' => MantenimientosController::class,
        'gmantenimientos' => GmantenimientosController::class,
        'archivos' => ArchivosController::class,
        'garchivos' => GarchivosController::class,
        'cronogramas' => CronogramasController::class,
    ]);

    Route::get('getData', [InventarioController::class, 'getData']);
    Route::get('getCat', [InventarioController::class, 'getCat']);
    Route::get('crearQrs', [InventarioController::class, 'crearQrs']);
    Route::post('importData', [InventarioController::class, 'importData']);
    Route::post('importDataCronos', [CronogramasController::class, 'importData']);
    Route::get('exportBase', [InventarioController::class, 'exportBase']);
    Route::get('exportBaseCronos', [CronogramasController::class, 'exportBase']);
    Route::get('getDataG', [GinventariosController::class, 'getData']);
    Route::get('getCatG', [GinventariosController::class, 'getCat']);
    Route::get('crearQrsG', [GinventariosController::class, 'crearQrs']);
    Route::post('importDataG', [GinventariosController::class, 'importData']);
    Route::get('exportBaseG', [GinventariosController::class, 'exportBase']);
    Route::get('downloadQrG', [GinventariosController::class, 'downloadQr']);
    Route::get('downloadQr', [InventarioController::class, 'downloadQr']);
    Route::get('obtenerEstadisticas', [InventarioController::class, 'obtenerEstadisticas']);
