<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cronogramas', function (Blueprint $table) {
            $table->id();
            $table->dateTime('instalacion')->nullable();
            $table->integer('calibracion')->nullable();
            $table->integer('frecuencia')->nullable();
            $table->string('serie')->nullable();
            $table->string('responsable')->nullable();
            $table->foreignId('inventario_id')
            ->references('id')
            ->on('inventarios')
            ->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cronogramas');
    }
};
