<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;

class subcategorias extends Model
{
    use HasFactory, Notifiable, SoftDeletes;
    protected $fillable = [
        'nombre',
        'color',
        'general',
        'categoria_id'
    ];

    public function categorias(): BelongsTo
    {
        return $this->belongsTo(categorias::class,'categoria_id');
    }

    public function categoria()
    {
        return $this->belongsTo(categorias::class, 'categoria_id');
    }

    public function inventarios()
    {
        return $this->hasMany(Inventario::class, 'subcategoria_id');
    }

    public function ginventarios()
    {
        return $this->hasMany(Ginventarios::class, 'subcategoria_id');
    }
}
